/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.monitor.service.impl;

import com.tp_link.eap.d.b;
import com.tp_link.eap.domain.eap.ClientHistory;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.monitor.monitor.repo.ClientHistoryRepository;
import com.tp_link.eap.monitor.monitor.service.c;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.util.a.a;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.l;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="clientHistoryService")
public class ClientHistoryService
extends com.tp_link.eap.i.a.a<ClientHistory>
implements c {
    @Autowired
    private ClientHistoryRepository a;
    @Autowired
    private MongoTemplate b;
    private Logger c = LoggerFactory.getLogger(this.getClass());

    public List<ClientHistory> getList(QueryPage queryPage) {
        return this.a.getByFilters(queryPage, null, null, null);
    }

    public List<ClientHistory> getList(QueryPage queryPage, QuerySort querySort) {
        return this.a.getByFilters(queryPage, querySort, null, null);
    }

    public List<ClientHistory> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.a.getByFilters(queryPage, null, filters, searchFilters);
    }

    public List<ClientHistory> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.a.getByFilters(queryPage, querySort, filters, searchFilters);
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.a.countByFilters(filters, searchFilters);
    }

    @Override
    public List<ClientHistory> getAll() {
        return com.tp_link.eap.util.a.a.a((Iterable)this.a.findAll());
    }

    @Override
    public void addHistory(ClientHistory ch) {
        this.a();
        this.a.save(ch);
    }

    @Override
    public void addHistories(List<ClientHistory> clientHistoryList) {
        this.a.save(clientHistoryList);
        this.a();
    }

    @Override
    public void deleteBySite() {
        String string = com.tp_link.eap.d.b.a();
        List<ClientHistory> list = this.a.findBySite(string);
        if (!CollectionUtils.isEmpty(list)) {
            this.a.delete(list);
        }
    }

    @Override
    public ClientHistory getLatestHistory(String clientMac, String site) {
        if (clientMac == null) {
            return null;
        }
        com.tp_link.eap.d.b.b((String)site);
        ArrayList<QueryFilter> arrayList = new ArrayList<QueryFilter>();
        arrayList.add(new QueryFilter("clientMac", (Object)clientMac, QueryFilter.FilterType.eq));
        List<ClientHistory> list = this.getList(new QueryPage(0, 1), new QuerySort(QuerySort.SortDirection.desc, "lastSeen"), arrayList, null);
        if (!CollectionUtils.isEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public ClientHistory getClientHistoryById(String id) {
        if (id == null) {
            return null;
        }
        return (ClientHistory)this.a.findOne((Serializable)((Object)id));
    }

    @Override
    public OperationResponse getClientHistory(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.c.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        if (e.a((String)queryData.getSortName())) {
            queryData.setSortName("lastSeen");
            queryData.setSortOrder("desc");
        }
        Grid grid = new Grid(queryData);
        String string = (String)queryData.getFilters().get("clientMac");
        if (!e.a((String)string)) {
            grid.initFilters("clientMac", (Object)string, QueryFilter.FilterType.eq);
        }
        long l2 = this.count(grid);
        grid.setTotalRows(l2);
        List list = this.getList(grid);
        grid.setData(list);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public List<ClientHistory> getClientHistoryAfterTime(long time) {
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"lastSeen").gte((Object)time));
        return this.b.find(query, ClientHistory.class);
    }

    @Override
    public void deleteAll() {
        this.b.dropCollection("clienthistory");
        this.b.createCollection("clienthistory");
    }

    private void a() {
        if (l.b()) {
            return;
        }
        long l2 = this.a.count();
        while (l2 != 0L && l2 >= 201000L) {
            this.c.info("client history {} reached maximum", (Object)l2);
            this.a.clearTop(1000, "lastSeen");
            l2 = this.a.count();
            this.c.info("after clear num is {}", (Object)l2);
        }
    }
}

